class Mutator_BaseMutator extends Mutator config(Monsterhunt2);

var config int DropItemsLevel; 		//0=Drop none, 1=Drop little, 2=Drop some, 3=Drop many, 4=Drop a lot & 5=Spam items
var config int MonsterSkillLevel;	//0 to 10
var config bool bUseMines;		//define if monsters can drop mines or not.
var config int ChanceToSpawnMine;	//chance in pct to spawn mine

var DeathMatchPlus MyGame;
var bool bInit;
var int TimerEvent;

function HandleSkilledPlayers()
{
local Pawn P;
local Info_PRI PRI;

	PRI = Info_PRI(PlayerPawn(P).PlayerReplicationInfo);

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			PRI = Info_PRI(PlayerPawn(P).PlayerReplicationInfo);

			//Illumination skill
			if ( PRI.LightRadius > 0 )
				{
				P.LightCone = 102;
				P.LightType = LT_Steady;
				P.LightBrightness = 70;
				P.LightHue = 0;
				P.LightSaturation = 192;
				P.LightRadius = 2 + PRI.LightRadius;
				}

			//Health Regain skill
			if ( PRI.HealthRegain > 0 )
				{
				P.Health += PRI.HealthRegain;
				if ( P.Health > PRI.HealthMax )
					{
					P.Health = PRI.HealthMax;
					}
				}
			//Ammo Regain skill
			if ( PRI.AmmoRegain > 0 && P.Weapon.AmmoType.AmmoAmount != 0 && P.Weapon.AmmoType.AmmoAmount < PRI.AmmoRegain * 25 )
				{
				P.Weapon.AmmoType.AmmoAmount += PRI.AmmoRegain;
				if ( P.Weapon.AmmoType.AmmoAmount > PRI.AmmoRegain * 25 )
					{
					P.Weapon.AmmoType.AmmoAmount = PRI.AmmoRegain * 25;
					}
				}
			}
		}


}

function SetMonsterSkillLevel()
{
local MH2 M;
local float Level;

	if (MonsterSkillLevel <= 0)
		{
		Level = 1;
		}
	else if (MonsterSkillLevel == 1)
		{
		Level = 1.25;
		}
	else if (MonsterSkillLevel == 2)
		{
		Level = 1.5;
		}
	else if (MonsterSkillLevel == 3)
		{
		Level = 1.75;
		}
	else if (MonsterSkillLevel == 4)
		{
		Level = 2;
		}
	else if (MonsterSkillLevel == 5)
		{
		Level = 2.25;
		}
	else if (MonsterSkillLevel == 6)
		{
		Level = 2.5;
		}
	else if (MonsterSkillLevel == 7)
		{
		Level = 2.75;
		}
	else if (MonsterSkillLevel == 8)
		{
		Level = 3;
		}
	else if (MonsterSkillLevel == 9)
		{
		Level = 3.25;
		}
	else
		{
		Level = 3.5;
		}

	ForEach AllActors(class'MH2', M)
		{

		//log("Monsters Initial Health:"@M.Health);

		M.Health = M.Health * Level;
		M.SightRadius = M.SightRadius * Level;
		M.Aggressiveness = M.Aggressiveness * Level;
		M.ReFireRate = M.ReFireRate * Level;
		M.CombatStyle = M.CombatStyle * Level;
		M.ProjectileSpeed = M.ProjectileSpeed * Level;
		M.GroundSpeed = M.GroundSpeed * Level;
		M.AirSpeed = M.AirSpeed * Level;
		M.WaterSpeed = M.WaterSpeed * Level;

		//log("Monsters New Health:"@M.Health$" When amped with:"@Level);

		}


}

function PostBeginPlay() 
{
	MyGame = DeathMatchPlus(Level.Game);
	Super.PostBeginPlay();

	settimer(0.5, true);

	SetMonsterSkillLevel();

	if ( ChanceToSpawnMine < 1 )
		ChanceToSpawnMine = 1;
	else if ( ChanceToSpawnMine > 100 )
		ChanceToSpawnMine = 100;

	log("Mutator_BaseMutator Initialized");
}

function Timer()
{
	
	//Super(TeamGamePlus).Timer();

	if ( TimerEvent == 0 )
		{
		HandleSkilledPlayers();
		TimerEvent++;
		}
	else if ( TimerEvent == 1 )
		{
		CrossLifeControl();
		TimerEvent = 0;
		}
}


function PreCacheReferences()
{
  // container code
}

function bool AlwaysKeep(Actor Other) 
{
	if (Other.IsA('TournamentPlayer'))
        	{
		Pawn(Other).PlayerReplicationInfoClass = class'Info_PRI';
		return true;
		}
        if (Other.IsA('Bot'))
        	{
		Pawn(Other).PlayerReplicationInfoClass = class'Info_PRI';
		return true;
		}
	if (Other.IsA('Inventory'))
		{
		if (Other.IsA('enforcer'))
			{
			enforcer(Other).PickupAmmoCount=200;
			}
/*		if ( !Other.IsA('SCUBAGear') || !Other.IsA('UT_JumpBoots'))
			{
			Inventory(Other).RespawnTime = 0.0;
			}
*/
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int AmmoCount;
local MH2_Weapon_Lawgiver Lawgiver;
local MH2_Weapon_Railgun Railgun;
local MH2_Weapon_Headremover Headremover;
local MH2_Weapon_Instigator Instigator;
local MH2_Weapon_Shredder Shredder;
local MH2_Weapon_Blaster Blaster;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if (inv.IsA('Weapon') && !inv.IsA('ImpactHammer'))
			{
			weap = Weapon(inv);

			AmmoCount = Weap.AmmoType.AmmoAmount;

			//spawn inventory item to world:
			if (Weap.IsA('MH2_Weapon_Lawgiver'))
				{
				dropped = Spawn(class'MH2_Weapon_Lawgiver',,,Killed.Location);
				MH2_Weapon_Lawgiver(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else if (Weap.IsA('MH2_Weapon_Railgun'))
				{
				dropped = Spawn(class'MH2_Weapon_Railgun',,,Killed.Location);
				MH2_Weapon_Railgun(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else if (Weap.IsA('MH2_Weapon_Headremover'))
				{
				dropped = Spawn(class'MH2_Weapon_Headremover',,,Killed.Location);
				MH2_Weapon_Headremover(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else if (Weap.IsA('MH2_Weapon_Instigator'))
				{
				dropped = Spawn(class'MH2_Weapon_Instigator',,,Killed.Location);
				MH2_Weapon_Instigator(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else if (Weap.IsA('MH2_Weapon_Shredder'))
				{
				dropped = Spawn(class'MH2_Weapon_Shredder',,,Killed.Location);
				MH2_Weapon_Shredder(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else if (Weap.IsA('MH2_Weapon_Blaster'))
				{
				dropped = Spawn(class'MH2_Weapon_Blaster',,,Killed.Location);
				MH2_Weapon_Blaster(dropped).WeaponOwner = Killed.PlayerReplicationInfo.PlayerName;
				}
			else
				{
				dropped = Spawn(weap.Class,,,Killed.Location);
				}

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = AmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			else if (Ammo(inv) == None)
				{
				dropped = Spawn(inv.Class,,,Killed.Location);
				inv = Inventory(dropped);
				inv.Charge = Rand(100);
				if (inv != None)
					{
					inv.RespawnTime = 0.0;
					inv.BecomePickup();
					}
				}
			}
		Killed.Inventory.Destroy();
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if (Other.IsA('JumpBoots'))
		{
		ReplaceWith(Other, "BotPack.UT_JumpBoots");
		Return false;
		}
	return True;
}

function CrossLifeControl()
{
local MH2_Pickup_Cross Soul;

	ForEach AllActors(class'MH2_Pickup_Cross', Soul)
		{
		Soul.LifeTime--;
		if ( Soul.LifeTime <= 0 )
			{
			Spawn(Class'BotPack.UT_SpriteSmokePuff',,,Soul.Location);
			Soul.Destroy();
			}
		}
}


function Tick(float Delta)
{
local Carcass C;
local MH2_Pickup_Cross Soul;

	//carcass effex

	ForEach AllActors(class'Carcass', C)
		{
		if (!C.IsA('HumanCarcass'))
			{
			C.bUnlit = True;
			C.Style = STY_Translucent;
			C.MultiSkins[0] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[1] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[2] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[3] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[4] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[5] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[6] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			C.MultiSkins[7] = WetTexture'UnrealShare.Belt_fx.Damagewet';
			if ( C.IsA('CreatureCarcass'))
				{
				C.DrawScale -= 0.01;
				C.SetCollision();
				if (C.DrawScale <= 0)
					{
					Soul = Spawn(Class'MH2_Pickup_Cross',,,C.Location+Vect(0,0,20));
					Soul.RemoteRole = ROLE_DumbProxy;
					Soul.SetPhysics(PHYS_Falling);
					Soul.bCollideWorld = true;
					C.Destroy();
					}
				}
			}
		}

		
}

function ScoreKill(Pawn Killer, Pawn Other)
{

	if (DropItemsLevel > 0 && !Other.bIsPlayer )
		{
		DropItems(Other);
		}


}

function DropItems(Pawn Other)
{
local int	HealthChance,
		AmmoChance,
		WeaponChance,
		ArmorChance,
		GoldChance,
		Dice;
local Inventory	DropItem;
local float 	speed;
local inventory inv;

	if (DropItemsLevel > 5 )
		{
		DropItemsLevel = 5;
		}

	if (DropItemsLevel == 1)
		{
		HealthChance = 10;
		AmmoChance = 10;
		WeaponChance = 5;
		ArmorChance = 5;
		GoldChance = 3;
		}
	else if (DropItemsLevel == 2)
		{
		HealthChance = 20;
		AmmoChance = 20;
		WeaponChance = 15;
		ArmorChance = 15;
		GoldChance = 6;
		}
	else if (DropItemsLevel == 3)
		{
		HealthChance = 33;
		AmmoChance = 33;
		WeaponChance = 25;
		ArmorChance = 20;
		GoldChance = 10;
		}
	else if (DropItemsLevel == 4)
		{
		HealthChance = 50;
		AmmoChance = 50;
		WeaponChance = 35;
		ArmorChance = 25;
		GoldChance = 12;
		}
	else
		{
		HealthChance = 75;
		AmmoChance = 75;
		WeaponChance = 40;
		ArmorChance = 30;
		GoldChance = 15;
		}
	//Armor:
	Dice = Rand(100);
	if ( ArmorChance > Dice )
		{
		Dice = Rand(3);
		if (Dice == 0)
			{
			DropItem = Spawn(Class'MH2_Pickup_Armor2',,,Other.Location);
			}
		else if (Dice == 1)
			{
			DropItem = Spawn(Class'MH2_Pickup_SuperArmor2',,,Other.Location);
			}
		else if (Dice == 2)
			{
			DropItem = Spawn(Class'MH2_Pickup_Shielding',,,Other.Location);
			}
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		DropItem.RespawnTime = 0.0;
		}
	//Gold:
	Dice = Rand(100);
	if ( GoldChance > Dice )
		{
		Dice = Rand(10);
		if (Dice == 0)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold',,,Other.Location);
			}
		else if (Dice == 1)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold2',,,Other.Location);
			}
		else if (Dice == 2)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold3',,,Other.Location);
			}
		else if (Dice == 3)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold4',,,Other.Location);
			}
		else if (Dice == 4)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold5',,,Other.Location);
			}
		else if (Dice == 5)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold6',,,Other.Location);
			}
		else if (Dice == 6)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold7',,,Other.Location);
			}
		else if (Dice == 7)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold8',,,Other.Location);
			}
		else if (Dice == 8)
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold9',,,Other.Location);
			}
		else
			{
			DropItem = Spawn(Class'MH2_Pickup_Gold10',,,Other.Location);
			}
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		DropItem.RespawnTime = 0.0;
		}
	//Health:
	Dice = Rand(100);
	if ( HealthChance > Dice )
		{
		Dice = Rand(8);
		if (Dice == 0)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health',,,Other.Location);
			}
		else if (Dice == 1)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health10',,,Other.Location);
			}
		else if (Dice == 2)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health15',,,Other.Location);
			}
		else if (Dice == 3)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health20',,,Other.Location);
			}
		else if (Dice == 4)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health25',,,Other.Location);
			}
		else if (Dice == 5)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health50',,,Other.Location);
			}
		else if (Dice == 6)
			{
			DropItem = Spawn(Class'MH2_Pickup_Health100',,,Other.Location);
			}
		else
			{
			DropItem = Spawn(Class'MH2_Pickup_HealthMax',,,Other.Location);
			}
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		DropItem.RespawnTime = 0.0;
		}
	//Ammo:
	Dice = Rand(100);
	if ( AmmoChance > Dice )
		{
		Dice = Rand(16);
		if (Dice == 0)
			{
			DropItem = Spawn(Class'UnrealShare.ASMDAmmo',,,Other.Location);
			}
		else if (Dice == 1)
			{
			DropItem = Spawn(Class'UnrealI.FlakBox',,,Other.Location);
			}
		else if (Dice == 2)
			{
			DropItem = Spawn(Class'UnrealI.RazorAmmo',,,Other.Location);
			}
		else if (Dice == 3)
			{
			DropItem = Spawn(Class'UnrealI.RifleAmmo',,,Other.Location);
			}
		else if (Dice == 4)
			{
			DropItem = Spawn(Class'UnrealShare.RocketCan',,,Other.Location);
			}
		else if (Dice == 5)
			{
			DropItem = Spawn(Class'UnrealShare.ShellBox',,,Other.Location);
			}
		else if (Dice == 6)
			{
			DropItem = Spawn(Class'UnrealI.Sludge',,,Other.Location);
			}
		else if (Dice == 7)
			{
			DropItem = Spawn(Class'UnrealShare.StingerAmmo',,,Other.Location);
			}
		else if (Dice == 8)
			{
			DropItem = Spawn(Class'BotPack.BioAmmo',,,Other.Location);
			}
		else if (Dice == 9)
			{
			DropItem = Spawn(Class'BotPack.BulletBox',,,Other.Location);
			}
		else if (Dice == 10)
			{
			DropItem = Spawn(Class'BotPack.FlakAmmo',,,Other.Location);
			}
		else if (Dice == 11)
			{
			DropItem = Spawn(Class'BotPack.Miniammo',,,Other.Location);
			}
		else if (Dice == 12)
			{
			DropItem = Spawn(Class'BotPack.PAmmo',,,Other.Location);
			}
		else if (Dice == 13)
			{
			DropItem = Spawn(Class'BotPack.RocketPack',,,Other.Location);
			}
		else if (Dice == 14)
			{
			DropItem = Spawn(Class'BotPack.ShockCore',,,Other.Location);
			}
		else
			{
			DropItem = Spawn(Class'BotPack.BladeHopper',,,Other.Location);
			}
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		DropItem.RespawnTime = 0.0;
		}
	//Weapon:
	Dice = Rand(100);
	if ( WeaponChance > Dice )
		{
		Dice = Rand(20);
		if (Dice == 0)
			{
			DropItem = Spawn(Class'UnrealShare.AutoMag',,,Other.Location);
			}
		else if (Dice == 1)
			{
			DropItem = Spawn(Class'UnrealShare.DispersionPistol',,,Other.Location);
			}
		else if (Dice == 2)
			{
			DropItem = Spawn(Class'UnrealShare.Eightball',,,Other.Location);
			}
		else if (Dice == 3)
			{
			DropItem = Spawn(Class'UnrealI.FlakCannon',,,Other.Location);
			}
		else if (Dice == 4)
			{
			DropItem = Spawn(Class'UnrealI.GESBioRifle',,,Other.Location);
			}
		else if (Dice == 5)
			{
			DropItem = Spawn(Class'UnrealI.Minigun',,,Other.Location);
			}
		else if (Dice == 7)
			{
			DropItem = Spawn(Class'UnrealI.Razorjack',,,Other.Location);
			}
		else if (Dice == 8)
			{
			DropItem = Spawn(Class'UnrealI.Rifle',,,Other.Location);
			}
		else if (Dice == 9)
			{
			DropItem = Spawn(Class'UnrealShare.ASMD',,,Other.Location);
			}
		else if (Dice == 10)
			{
			DropItem = Spawn(Class'UnrealShare.Stinger',,,Other.Location);
			}
		else if (Dice == 11)
			{
			DropItem = Spawn(Class'BotPack.enforcer',,,Other.Location);
			}
		else if (Dice == 12)
			{
			DropItem = Spawn(Class'BotPack.minigun2',,,Other.Location);
			}
		else if (Dice == 13)
			{
			DropItem = Spawn(Class'BotPack.PulseGun',,,Other.Location);
			}
		else if (Dice == 14)
			{
			DropItem = Spawn(Class'BotPack.ripper',,,Other.Location);
			}
		else if (Dice == 15)
			{
			DropItem = Spawn(Class'BotPack.ShockRifle',,,Other.Location);
			}
		else if (Dice == 16)
			{
			DropItem = Spawn(Class'BotPack.SniperRifle',,,Other.Location);
			}
		else if (Dice == 17)
			{
			DropItem = Spawn(Class'BotPack.ut_biorifle',,,Other.Location);
			}
		else if (Dice == 18)
			{
			DropItem = Spawn(Class'BotPack.UT_Eightball',,,Other.Location);
			}
		else if (Dice == 19)
			{
			DropItem = Spawn(Class'BotPack.UT_FlakCannon',,,Other.Location);
			}
		else
			{
			DropItem = Spawn(Class'BotPack.WarheadLauncher',,,Other.Location);
			}
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		DropItem.RespawnTime = 0.0;
		}

	//Randomly drop mine
	Dice = Rand(100 / ChanceToSpawnMine);
	if ( Dice == 0 && bUseMines )
		{
		DropItem = Spawn(Class'MH2_TriggeredMine',,,Other.Location+Vect(20,20,0));
		speed = VSize(Other.Velocity);
		DropItem.RemoteRole = ROLE_DumbProxy;
		DropItem.SetPhysics(PHYS_Falling);
		DropItem.bCollideWorld = true;
		DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
		DropItem.RespawnTime = 0.0;
		}

	
}

defaultproperties
{
}
